/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.VI;

import com.quantumdata.VI.FrontPanel;
import com.quantumdata.VI.VIPlugIn;
import com.quantumdata.cmdterm.QDCmdLinePlugin;
import com.quantumdata.ftpbrowser.FtpBrowserPlugIn;
import com.quantumdata.std.IQDConsole;
import com.quantumdata.std.IQDPluginContext;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.std.InstrumentResponse;
import com.quantumdata.std.QDUtil;
import com.quantumdata.std.RemoteInstrument;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.Timer;

public class VIPanel
extends JPanel
implements ActionListener,
IQDConsole {
    private static final long serialVersionUID = 1L;
    private RemoteInstrument m_instrument = null;
    private JLabel m_statusLine;
    private JLabel m_infoLineTop;
    private JLabel m_infoLineBot;
    private FrontPanel m_frontPanel;
    private Timer m_statusClearer = null;
    IQDPluginContext m_context;
    int m_cmdCnt = 0;

    public VIPanel(IQDPluginContext iQDPluginContext) {
        this.m_context = iQDPluginContext;
        this.m_instrument = iQDPluginContext.getConnectionManager().getDefaultInstrument();
        this.m_instrument.setConsole(this);
        this.createComponents();
    }

    protected void createComponents() {
        this.m_statusLine = new JLabel("  ");
        this.m_statusLine.setBackground(new Color(128, 0, 128));
        this.m_statusLine.setForeground(Color.WHITE);
        this.m_statusLine.setOpaque(true);
        this.m_statusLine.setHorizontalAlignment(0);
        this.m_infoLineTop = new JLabel("  ");
        this.m_infoLineTop.setBackground(new Color(128, 0, 128));
        this.m_infoLineTop.setForeground(Color.WHITE);
        this.m_infoLineTop.setOpaque(true);
        this.m_infoLineTop.setHorizontalAlignment(0);
        this.m_infoLineTop.setFont(new Font("Courier", 1, 14));
        this.m_infoLineBot = new JLabel("  ");
        this.m_infoLineBot.setBackground(new Color(128, 0, 128));
        this.m_infoLineBot.setForeground(Color.WHITE);
        this.m_infoLineBot.setOpaque(true);
        this.m_infoLineBot.setHorizontalAlignment(0);
        this.m_infoLineBot.setFont(new Font("Courier", 1, 12));
        JLabel jLabel = new JLabel("Quantum Data Virtual Instrument: Version 1.0, Build 19");
        jLabel.setBackground(new Color(128, 0, 128));
        jLabel.setForeground(Color.WHITE);
        jLabel.setOpaque(true);
        jLabel.setHorizontalAlignment(0);
        jLabel.setFont(new Font("Courier", 1, 16));
        VIPanel vIPanel = this;
        vIPanel.setLayout(new BorderLayout());
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("Options");
        JMenuItem jMenuItem = new JMenuItem("Connect To...");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Connect");
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("CMD Terminal...");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("CmdTerm");
        jMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("FTP Browser...");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Browse");
        jMenu.add(jMenuItem);
        jMenu.addSeparator();
        jMenuItem = new JMenuItem("Refresh Display");
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand("Update");
        jMenu.add(jMenuItem);
        jMenuBar.add(jMenu);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jMenuBar, "North");
        jPanel.add((Component)this.m_infoLineTop, "Center");
        jPanel.add((Component)this.m_infoLineBot, "South");
        vIPanel.add((Component)jPanel, "North");
        jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jLabel, "North");
        jPanel.add((Component)this.m_statusLine, "South");
        vIPanel.add((Component)jPanel, "South");
        this.m_frontPanel = new FrontPanel();
        this.m_frontPanel.initialize(this.m_instrument);
        vIPanel.add((Component)this.m_frontPanel, "Center");
    }

    public void start() {
        this.m_statusLine.setText("Please wait while connecting...");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VIPanel.this.m_statusLine.setText("");
            }
        };
        this.m_statusClearer = new Timer(5000, actionListener);
        this.m_statusClearer.setRepeats(true);
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VIPanel.this.m_frontPanel.updateLcd();
                VIPanel.this.m_frontPanel.updateLeds();
                String string = "Connected to: " + VIPanel.this.m_instrument.getConnection().getName();
                VIPanel.this.m_infoLineTop.setText(string);
                string = "";
                InstrumentResponse instrumentResponse = VIPanel.this.m_instrument.sendCmd("*idn?");
                if (!instrumentResponse.isError()) {
                    String string2 = instrumentResponse.getResponse();
                    int n = string2.indexOf(44);
                    string2 = string2.substring(n + 1, n + 4);
                    VIPanel.this.m_frontPanel.setModel(string2);
                    string = string + "   IDN: " + instrumentResponse.getResponse();
                }
                if (!(instrumentResponse = VIPanel.this.m_instrument.sendCmd("VERG?")).isError()) {
                    string = string + "   Gateware: " + instrumentResponse.getResponse();
                }
                VIPanel.this.m_infoLineBot.setText(string);
                VIPanel.this.m_statusClearer.start();
            }
        };
        if (!this.m_instrument.isConnected()) {
            try {
                this.m_instrument.connect();
            }
            catch (InstrumentException instrumentException) {
                this.m_statusLine.setText("*** CONNECTION FAILED: " + instrumentException.getMessage() + " ***");
                return;
            }
        }
        Timer timer = new Timer(1000, actionListener2);
        timer.setRepeats(false);
        timer.start();
    }

    public void stop() {
        this.m_instrument.disconnect();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("CmdTerm")) {
            this.LaunchCmdTerminal();
            return;
        }
        if (actionEvent.getActionCommand().equals("Update")) {
            this.UpdatePanel();
            return;
        }
        if (actionEvent.getActionCommand().equals("Browse")) {
            this.Browse();
        }
        if (actionEvent.getActionCommand().equals("Connect")) {
            VIPlugIn vIPlugIn = new VIPlugIn();
            JFrame jFrame = QDUtil.runStandalonePlugIn(vIPlugIn, this.m_context);
            jFrame.setTitle("Virtual Front Panel: Secondary Window");
            jFrame.setDefaultCloseOperation(2);
        }
    }

    private void LaunchCmdTerminal() {
        String string = this.m_instrument.getConnection().getName();
        QDCmdLinePlugin qDCmdLinePlugin = new QDCmdLinePlugin();
        JFrame jFrame = QDUtil.runStandalonePlugIn(qDCmdLinePlugin, this.m_context);
        jFrame.setTitle("CMD Terminal: " + string);
        jFrame.setDefaultCloseOperation(2);
    }

    private void UpdatePanel() {
        this.m_frontPanel.updateLcd();
        this.m_frontPanel.updateLeds();
    }

    private void Browse() {
        String string = this.m_instrument.getConnection().getName();
        FtpBrowserPlugIn ftpBrowserPlugIn = new FtpBrowserPlugIn();
        JFrame jFrame = QDUtil.runStandalonePlugIn(ftpBrowserPlugIn, this.m_context);
        jFrame.setTitle("Instrument FTP Browser : " + string);
        jFrame.setDefaultCloseOperation(2);
    }

    public void println(String string) {
        if (this.m_statusClearer != null) {
            this.m_statusClearer.restart();
        }
        this.m_statusLine.setText(string);
    }
}

